import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the grid size
rows, cols = 6, 4

# Create a figure and axis
fig, ax = plt.subplots(figsize=(6, 9))

# Define colors for pieces and statuses
colors = {
    'rightl0': 'blue',
    'rightl1': 'green',
    'square0': 'red',
    'square1': 'yellow',
    'clear': 'lightgrey'
}

# Define positions for pieces
pieces = {
    'rightl0': [(3, 0), (3, 1), (2, 0)],
    'rightl1': [(1, 0), (1, 1), (0, 0)],
    'square0': [(1, 2)],
    'square1': [(2, 2)]
}

# Define clear positions
clear_positions = [
    (5, 0), (5, 1), (5, 2), (5, 3),
    (4, 0), (4, 1), (4, 2), (4, 3),
    (3, 2), (3, 3),
    (2, 1), (2, 3),
    (1, 3),
    (0, 1), (0, 2), (0, 3)
]

# Draw grid and pieces
for row in range(rows):
    for col in range(cols):
        position = (row, col)
        if position in pieces['rightl0']:
            color = colors['rightl0']
            label = 'rightl0'
            status = 'occupied'
        elif position in pieces['rightl1']:
            color = colors['rightl1']
            label = 'rightl1'
            status = 'occupied'
        elif position in pieces['square0']:
            color = colors['square0']
            label = 'square0'
            status = 'occupied'
        elif position in pieces['square1']:
            color = colors['square1']
            label = 'square1'
            status = 'occupied'
        elif position in clear_positions:
            color = colors['clear']
            label = f'f{row}-{col}f'
            status = 'free'
        else:
            continue

        # Draw the grid cell or piece
        rect = patches.Rectangle((col, rows - 1 - row), 1, 1, linewidth=3 if label.startswith('rightl') else 2, 
                                 edgecolor='black', facecolor=color)
        ax.add_patch(rect)

        # Add text for label and status
        ax.text(col + 0.5, rows - 1 - row + 0.75, label, ha='center', va='center', fontsize=8, color='white' if color != 'lightgrey' else 'black')
        ax.text(col + 0.5, rows - 1 - row + 0.25, status, ha='center', va='center', fontsize=8, color='white' if color != 'lightgrey' else 'black')

# Add legend
legend_labels = [patches.Patch(color=color, label=f'{label} ({status})') for label, color, status in zip(
    ['rightl0', 'rightl1', 'square0', 'square1', 'clear'],
    ['blue', 'green', 'red', 'yellow', 'lightgrey'],
    ['occupied', 'occupied', 'occupied', 'occupied', 'free']
)]
ax.legend(handles=legend_labels, loc='upper right', bbox_to_anchor=(1.3, 1))

# Set axis limits and hide axes
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_xticks([])
ax.set_yticks([])
ax.set_aspect('equal')
plt.axis('off')

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_5.png', bbox_inches='tight')
plt.show()